% created by Nils Hase 2016 (nilshase@math.uni-bremen.de)

% function to get the indices of the pixels to a lat-lon rectangular region
% for the US methane setup

function indices = get_index(lon_left,lon_right,lat_low,lat_up)

load('synthetic_methane_data.mat','land_grids')
f = zeros(31,94);
f(land_grids) = 1:length(land_grids);

lat_to_index = @(lat) lat - 25 + 1;
lon_to_index = @(lon) lon + 145 + 1;

llon = -145:-52;
llat = 25:55;

dim_lon = round(lon_right-lon_left);
dim_lat = round(lat_up-lat_low);

indices = zeros(dim_lat,dim_lon);

f_temp = zeros(31,94);
f_temp(lat_to_index(lat_low):lat_to_index(lat_up),lon_to_index(lon_left):lon_to_index(lon_right)) = 1;
ff_temp = f_temp(land_grids);
indices = find(ff_temp == 1);

if sum(indices == 0) > 0
    fprintf('Warning!')
end

end
